/*
This code replicates Figure 2 of the paper: Corporate Foreign Exchange Debt in Emerging Markets

We show only aggregated data because of confidential issues. Non financial corporate FX debt data comes from two sources: 
 
1) Emergence of Asia: Reforms, Corporate Savings, and Global Imbalances (IMF 2016)
2) Exchange Rate Fluctuations and Firm Leverage (IMF 2021)
We build FX debt to annual GDP series and take the average for Emerging Markets. 
When 2) is not available, we use 1). 

Total external FX Debt comes from Cross-Border Currency Exposures. New evidence based on an enhanced and updated dataset (Bénetrix et al 19)
*/

clear
set more off
cls
clear matrix
clear mata 
set maxvar 8000
set graphics on

//Adjust this this directory: 
cap cd "Replication_pkg/Data"  
cap n log close _all

use "Data_fig2_new.dta", clear


twoway line FX_debt_f year , yaxis(1) lwidth(thick) lcolor(red) ytitle("", axis(1)) || ///
line fxdebt_to_gdp_annual year, yaxis(2) lwidth(thick) lcolor(blue) || ///
line DL_GDP year, yaxis(2) lwidth(thick) lcolor(black) || ///
 line L_debt_FC_GDP year, yaxis(2) lwidth(thick) lcolor(dkgreen)  ///
 legend(position(6) label(1 "Non-financial Private Sector FX Debt, % Total Debt (BIS) (LHS) ")   label(2 "Non-financial Private Sector FX Debt, % GDP (BIS) (RHS) ") label(3 "Total External Debt (Bénétrix et al 19) (RHS)") label(4 "Total External FX Debt (Bénétrix et al 19) (RHS) ")) ytitle("%", axis(1)) ytitle("% GDP" , axis(2)) xtitle("") ylab(5(5)20, nogrid axis(1))  xlab(1998(4)2022, nogrid) 
graph export "../Figure 2/fig2.pdf", replace
 
 
